/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.tyrus.container.grizzly.client.TaskProcessor;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Writer;

public class GrizzlyWriter
extends Writer {
    private final TaskProcessor taskProcessor;
    final Connection connection;

    public GrizzlyWriter(Connection connection) {
        this.connection = connection;
        this.connection.configureBlocking(false);
        this.taskProcessor = new TaskProcessor(new WriterCondition());
    }

    @Override
    public void write(final ByteBuffer buffer, final CompletionHandler<ByteBuffer> completionHandler) {
        if (!this.connection.isOpen()) {
            completionHandler.failed(new IllegalStateException("Connection is not open."));
            return;
        }
        Buffer message = Buffers.wrap(this.connection.getTransport().getMemoryManager(), buffer);
        EmptyCompletionHandler emptyCompletionHandler = new EmptyCompletionHandler(){

            @Override
            public void cancelled() {
                if (completionHandler != null) {
                    completionHandler.cancelled();
                }
            }

            @Override
            public void completed(Object result2) {
                if (completionHandler != null) {
                    completionHandler.completed(buffer);
                }
            }

            @Override
            public void failed(Throwable throwable2) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable2);
                }
            }
        };
        this.taskProcessor.processTask(new WriteTask(this.connection, message, emptyCompletionHandler));
    }

    @Override
    public void close() {
        this.taskProcessor.processTask(new CloseTask(this.connection));
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GrizzlyWriter && this.connection.equals(((GrizzlyWriter)obj).connection);
    }

    public String toString() {
        return this.getClass().getName() + " " + this.connection.toString() + " " + this.connection.hashCode();
    }

    private class CloseTask
    extends TaskProcessor.Task {
        private final Connection connection;

        private CloseTask(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void execute() {
            this.connection.closeSilently();
        }
    }

    private class WriteTask
    extends TaskProcessor.Task {
        private final Connection connection;
        private final Buffer message;
        private final EmptyCompletionHandler completionHandler;

        private WriteTask(Connection connection, Buffer message, EmptyCompletionHandler completionHandler) {
            this.connection = connection;
            this.message = message;
            this.completionHandler = completionHandler;
        }

        @Override
        public void execute() {
            this.connection.write(this.message, this.completionHandler);
        }
    }

    private class WriterCondition
    implements TaskProcessor.Condition {
        private WriterCondition() {
        }

        @Override
        public boolean isValid() {
            if (!GrizzlyWriter.this.connection.canWrite()) {
                try {
                    GrizzlyWriter.this.connection.notifyCanWrite(new WriteHandler(){

                        @Override
                        public void onWritePossible() throws Exception {
                            GrizzlyWriter.this.taskProcessor.processTask();
                        }

                        @Override
                        public void onError(Throwable t) {
                            Logger.getLogger(GrizzlyWriter.class.getName()).log(Level.WARNING, t.getMessage(), t);
                        }
                    });
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return false;
            }
            return true;
        }
    }
}

